#version 120

uniform sampler2D ParticleSampler;
uniform float Time;
uniform float InSize;

varying vec2 texCoord;
varying vec2 oneTexel;

uniform float weight[41] = float[] (0.0353, 0.0352, 0.0348, 0.0341, 0.0332, 0.032, 0.0307, 0.0292, 0.0275, 0.0257, 0.0239, 0.022, 0.0201, 0.0182, 0.0164, 0.0146, 0.013, 0.0114, 0.0099, 0.0086, 0.0074, 0.0063, 0.0053, 0.0045, 0.0037, 0.0031, 0.0025, 0.002, 0.0016, 0.0013, 0.001, 0.0008, 0.0006, 0.0005, 0.0004, 0.0003, 0.0002, 0.0002, 0.0001, 0.0001, 0.0001);
//uniform float weight[101] = float[] (0.0129, 0.0129, 0.0129, 0.0129, 0.0128, 0.0128, 0.0127, 0.0126, 0.0125, 0.0124, 0.0123, 0.0121, 0.012, 0.0118, 0.0117, 0.0115, 0.0113, 0.0111, 0.0109, 0.0107, 0.0105, 0.0103, 0.01, 0.0098, 0.0096, 0.0093, 0.0091, 0.0088, 0.0086, 0.0083, 0.0081, 0.0078, 0.0076, 0.0073, 0.0071, 0.0068, 0.0066, 0.0063, 0.0061, 0.0058, 0.0056, 0.0054, 0.0051, 0.0049, 0.0047, 0.0045, 0.0043, 0.0041, 0.0039, 0.0037, 0.0035, 0.0033, 0.0031, 0.003, 0.0028, 0.0027, 0.0025, 0.0024, 0.0022, 0.0021, 0.002, 0.0018, 0.0017, 0.0016, 0.0015, 0.0014, 0.0013, 0.0012, 0.0011, 0.0011, 0.001, 0.0009, 0.0009, 0.0008, 0.0007, 0.0007, 0.0006, 0.0006, 0.0005, 0.0005, 0.0005, 0.0004, 0.0004, 0.0004, 0.0003, 0.0003, 0.0003, 0.0002, 0.0002, 0.0002, 0.0002, 0.0002, 0.0002, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001);

void main() {
    vec4 particle_color = texture2D(ParticleSampler, texCoord);

    vec3 result = texture2D(ParticleSampler, texCoord).rgb * weight[0]; // current fragment's contribution

    for (int i = 1; i < 41; i ++) {
        result += texture2D(ParticleSampler, texCoord + vec2(oneTexel.x * i,0.0)).rgb * weight[i];
        result += texture2D(ParticleSampler, texCoord - vec2(oneTexel.x * i,0.0)).rgb * weight[i];
    }

    gl_FragColor = vec4(result, 1.0);
}